<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Course extends Model
{
    use HasFactory;

    protected $fillable = [
        'title',
        'description',
        'hours_number',
    ];

    public function lessons()
    {
        return $this->hasMany(Lesson::class,'course_id');
    }

    public function rooms()
    {
        return $this->hasMany(ClassRoom::class,'course_id');
    }

    #Scope
######################
#######################
public function scopeActive($query)
{
    return $query->where('is_active', 1);
}

}
